/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.items.stacks.providers;

import java.util.Optional;
import java.util.UUID;
import net.impactdev.impactor.api.items.AbstractedItemStack;
import net.impactdev.impactor.api.items.builders.provided.SkullStackBuilder;
import net.impactdev.impactor.api.items.extensions.SkullStack;
import net.impactdev.impactor.api.items.types.ItemTypes;
import net.impactdev.impactor.minecraft.items.stacks.builders.ImpactorSkullStackBuilder;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.minecraft.class_2512;

public final class ImpactorSkullStack
extends AbstractedItemStack
implements SkullStack {
    private final SkullStack.SkullType type;
    private final SkullStack.PlayerHeadMetadata metadata;

    public ImpactorSkullStack(ImpactorSkullStackBuilder builder) {
        super(builder.isPlayer ? ItemTypes.PLAYER_HEAD : builder.type.delegate(), builder);
        this.type = builder.type;
        this.metadata = builder.isPlayer ? new ImpactorPlayerHeadMetadata(builder.target, builder.texture) : null;
    }

    @Override
    public boolean supportsTextures() {
        return !this.skullType().isPresent();
    }

    @Override
    public Optional<SkullStack.SkullType> skullType() {
        return Optional.ofNullable(this.type);
    }

    @Override
    public Optional<SkullStack.PlayerHeadMetadata> playerMetadata() {
        return Optional.ofNullable(this.metadata);
    }

    @Override
    public CompoundBinaryTag nbt() {
        CompoundBinaryTag nbt = super.nbt();
        if (this.playerMetadata().isPresent()) {
            if (this.metadata.username().isPresent()) {
                if (!this.metadata.texture().isPresent()) {
                    nbt = (CompoundBinaryTag)nbt.putString("SkullOwner", this.metadata.username().get());
                } else {
                    CompoundBinaryTag owner = CompoundBinaryTag.empty();
                    owner.putString("Name", this.metadata.username().orElse("Impactor"));
                    this.properties(owner);
                    nbt = (CompoundBinaryTag)nbt.put("SkullOwner", (BinaryTag)owner);
                }
            } else if (this.metadata.texture().isPresent()) {
                CompoundBinaryTag owner = CompoundBinaryTag.empty();
                owner = (CompoundBinaryTag)owner.putIntArray("Id", class_2512.method_25929((UUID)UUID.randomUUID()).method_10588());
                owner = this.properties(owner);
                nbt = (CompoundBinaryTag)nbt.put("SkullOwner", (BinaryTag)owner);
            }
        }
        return nbt;
    }

    private CompoundBinaryTag properties(CompoundBinaryTag nbt) {
        CompoundBinaryTag properties = CompoundBinaryTag.empty();
        ListBinaryTag textures = ListBinaryTag.empty();
        CompoundBinaryTag value = CompoundBinaryTag.empty();
        value = (CompoundBinaryTag)value.putString("Value", this.metadata.texture().orElseThrow(() -> new IllegalStateException("No available texture")));
        textures = (ListBinaryTag)textures.add((BinaryTag)value);
        properties = (CompoundBinaryTag)properties.put("textures", (BinaryTag)textures);
        return (CompoundBinaryTag)nbt.put("Properties", (BinaryTag)properties);
    }

    public static class ImpactorPlayerHeadMetadata
    implements SkullStack.PlayerHeadMetadata {
        private final String username;
        private final String texture;

        public ImpactorPlayerHeadMetadata(String username, String texture) {
            this.username = username;
            this.texture = texture;
        }

        @Override
        public Optional<String> username() {
            return Optional.ofNullable(this.username);
        }

        @Override
        public Optional<String> texture() {
            return Optional.ofNullable(this.texture);
        }

        private void apply(SkullStackBuilder root) {
            if (this.username != null) {
                root.player(this.username, false);
            } else {
                root.player(this.texture, true);
            }
        }
    }
}

